import { Component, OnInit, Input} from '@angular/core';
import { ConceptServices } from '../../../../services/concept-services';
import { NgRedux } from 'ng2-redux';
import { IAppState } from '../../../../store';
import { Response } from '@angular/http';
import {
  CONCEPT_CARD_POPULATING,
  UPDATE_CONCEPT_CARD_TAB_SELECTION,
  SET_CURRENT_CONCEPT_SELECTED,
  NEW_CONCEPT_HISTORY,
  CONCEPT_CARD_POPULATED,
  ENABLE_CONCEPT_CARD_VIEW,
  RESET_ADD_MVP_STATE,
  SET_CARD_DATA,
  DISPLAY_CONCEPT_CARD_DETAIL
} from '../../../../actions';

@Component({
  selector: 'app-concept-card-metadata-interontology-item',
  templateUrl: './concept-card-metadata-interontology-item.component.html',
  styleUrls: ['./concept-card-metadata-interontology-item.component.scss']
})
export class ConceptCardMetadataInterontologyItemComponent implements OnInit {
  @Input() interOntologyObj;
  mouseOvered: boolean;
  constructor(
    private conceptServices: ConceptServices,
    private ngRedux: NgRedux<IAppState>) { }

  ngOnInit() {
  }

  accessConceptFromOntology(object) {
    this.conceptServices.getConcept(object.uri);
    // this.ngRedux.dispatch({
    //   type: CONCEPT_CARD_POPULATING
    // })
    // this.conceptServices
    // .populateConceptCard(null, object.uri)
    // .subscribe(
    //   (response: Response) => {
    //     if (response.status === 200) {
    //       const rdata = JSON.parse(response.text());
    //       this.ngRedux.dispatch({
    //         type: UPDATE_CONCEPT_CARD_TAB_SELECTION,
    //         payload: 'description'
    //       });
    //       this.ngRedux.dispatch({
    //         type: SET_CARD_DATA,
    //         payload: rdata.response
    //       });
    //       this.ngRedux.dispatch({
    //         type: SET_CURRENT_CONCEPT_SELECTED,
    //         payload: rdata.response
    //       });
    //       this.ngRedux.dispatch({
    //         type: NEW_CONCEPT_HISTORY,
    //         payload: rdata.response
    //       });
    //       this.ngRedux.dispatch({
    //         type: RESET_ADD_MVP_STATE
    //       });
    //       this.ngRedux.dispatch({
    //         type: CONCEPT_CARD_POPULATED
    //       });
    //       this.ngRedux.dispatch({
    //         type: ENABLE_CONCEPT_CARD_VIEW
    //       });
    //     }
    // });
  }

  displayOntologyText() {
    return (this.interOntologyObj.name == null || this.interOntologyObj.name == '' ? 
      this.interOntologyObj.uri : this.interOntologyObj.name); 
  }

  isLink(uri) {
    return this.conceptServices.isActiveLink(uri);
  }

}
